module load biobuilds
module load GATK/4.1.2
module load jdk/8


##collect variant quality metrics before filtration, after vqsr

INPUT=$1

##filtration
vcftools --gzvcf ${INPUT}.recalibrated.vcf.gz --minDP 8 --minGQ 20 --recode-INFO-all --recode --out ${INPUT}_GQ_DP_filt

~/bin/meanGQ_filter.sh ${INPUT}_GQ_DP_filt.recode.vcf ${INPUT}_GQ_DP_meanGQ_filt.vcf


## Apply callrate filter, snp has to be genotyped in at least 88% of the cohort
vcftools --vcf ${INPUT}_HWE_meanGQ_filt.vcf --max-missing 0.88 --recode-INFO-all --recode --out ${INPUT}_postfilt

